function [ W, Points ] = Weights_1D( dud )
%Calculate the weights for on unit element for uniformly spaced 5 pt grid.
%   Calculates the weights for a 5 point quadrature, ie is exact for
%   polynomials of degree 4 on the unit interval.  The weights are listed
%   on the ordered basis {1,x,x^2,x^3,x^4}.  Weights are given as a column
%   vector but top to bottom ordered like the {} basis. To be clear with
%   the weights we know, W^tr * Poly(@Points) = Int^1_0 Pdx.

%NOTE: In general it'd be easier to write this code not needing to evaluate
%the poly but just using its coefficients?  NO!  The point is that because
%weights defined via evaluations, you can evaluate these polynomials either
%pre or post mapping to the standard element!  You don't have to
%recalculate the coefficients passing from element to element which would
% be all the time matrix inversions!
dud = dud+1;
Points = [[0 .25 .5 .75 1]]';

A = [zeros(5,1)+1, Points, Points.^2, Points.^3, Points.^4];
%For P is poly on above ordered basis AP = column vector giving P evaluated
%at these points.  

%The weights satisfy the algebraic equation:
%W^tr*A(e1 e2 e3 e4 e5) = [\int^1_0 1dx, xdx, x^2dx, x^3dx, x^4dx]
%                       = [1  .5 1/3 .25 .2]
%That is the weights dot producted against a polynomial P evaluated at
%POINTS.  The right side identity matrix is making this relation hold over
%the standard basis.

%We deduce A^tr *W = [1 .5 .33 .25 .2]'
b = [1 .5 1/3 1/4 1/5]';
A = A'; %Transpose the A matrix
W = A\b; %Calculate the weights

end

